/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.util;

public class VersionDelimiter {
    public int major;
    public int minor;
    public int patch;

    public VersionDelimiter(String ss) {
        if (ss == null || ss.isEmpty()) {
            this.wipeVersion();
            return;
        }
        String[] split = ss.split("\\.");
        if (split.length != 3) {
            this.wipeVersion();
            return;
        }
        try {
            this.major = Integer.parseInt(split[0]);
            this.minor = Integer.parseInt(split[1]);
            this.patch = Integer.parseInt(split[2]);
        }
        catch (NumberFormatException e) {
            this.wipeVersion();
            return;
        }
    }

    public VersionDelimiter(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean isSameOrNewerVersion(VersionDelimiter vd) {
        return this.isSameOrNewerVersion(vd.major, vd.minor, vd.patch);
    }

    public boolean isSameOrNewerVersion(int major, int minor) {
        return this.isSameOrNewerVersion(major, minor, 0);
    }

    public boolean isSameOrNewerVersion(int major, int minor, int patch) {
        if (this.major > major) {
            return true;
        }
        if (this.major == major) {
            if (this.minor > minor) {
                return true;
            }
            if (this.minor == minor && this.patch >= patch) {
                return true;
            }
        }
        return false;
    }

    private void wipeVersion() {
        this.major = 0;
        this.minor = 0;
        this.patch = 0;
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.patch;
    }
}

